/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.rendering.RenderableVertices;

public abstract class AGUIComponent {
    public final int constructedX;
    public final int constructedY;
    public final Point3D position;
    public final Point3D textPosition;
    public int width;
    public int height;
    public boolean visible = true;
    public boolean ignoreGUILightingState;
    public String text;
    protected RenderableData renderable;
    private static final RenderableVertices mutableTooltipVertices = RenderableVertices.createSprite(9, null, null);
    private static final RenderableData mutableTooltipRenderable = new RenderableData(mutableTooltipVertices, "mts:textures/guis/standard.png");
    private static final Point3D mutableTooltipPosition = new Point3D();
    protected static final int TEXT_DEFAULT_ZOFFSET = 200;
    protected static final int MODEL_DEFAULT_ZOFFSET = 100;
    private static final int TOOLTIP_BORDER_PADDING = 4;
    private static final int TOOLTIP_SECTION_WIDTH = 100;
    private static final int TOOLTIP_SECTION_HEIGHT = 60;
    private static final int TOOLTIP_SECTION_BORDER = 3;
    private static final int TOOLTIP_SECTION_WIDTH_OFFSET = 100;
    private static final int TOOLTIP_SECTION_HEIGHT_OFFSET = 196;
    private static final float TOOLTIP_TEXTURE_WIDTH = 256.0f;
    private static final float TOOLTIP_TEXTURE_HEIGHT = 256.0f;

    public AGUIComponent(int x, int y, int width, int height) {
        this.constructedX = x;
        this.constructedY = y;
        this.position = new Point3D(x, -y, this.getZOffset());
        this.textPosition = new Point3D(this.position.x, this.position.y, this.position.z + 200.0);
        this.width = width;
        this.height = height;
    }

    public int getZOffset() {
        return 0;
    }

    public boolean isMouseInBounds(int mouseX, int mouseY) {
        return (double)mouseX >= this.position.x && (double)mouseY >= -this.position.y && (double)mouseX < this.position.x + (double)this.width && (double)mouseY < -this.position.y + (double)this.height;
    }

    public abstract void render(AGUIBase var1, int var2, int var3, boolean var4, boolean var5, boolean var6, float var7);

    public void renderText(boolean renderTextLit, int worldLightValue) {
    }

    public void renderTooltip(AGUIBase gui, int mouseX, int mouseY) {
        List<String> tooltipTextLines = this.getTooltipText();
        if (tooltipTextLines != null && !tooltipTextLines.isEmpty()) {
            int wrapWidth = gui.screenWidth - mouseX > mouseX ? gui.screenWidth - mouseX - 8 : mouseX - 8;
            float longestLineWidth = 0.0f;
            int linesOfText = 0;
            StringBuilder tooltipCombinedText = new StringBuilder();
            for (String tooltipText : tooltipTextLines) {
                float lineWidth = RenderText.getStringWidth(tooltipText, null) * 2.0f;
                linesOfText = (int)((double)linesOfText + Math.ceil(lineWidth / (float)wrapWidth));
                tooltipCombinedText.append(tooltipText).append("\n");
                if (!(lineWidth > longestLineWidth)) continue;
                longestLineWidth = lineWidth;
            }
            int actualStringWidth = (int)(longestLineWidth > (float)wrapWidth ? (float)wrapWidth : longestLineWidth);
            int actualStringHeight = (int)Math.ceil(RenderText.getHeight(linesOfText));
            int xOffset = gui.screenWidth - mouseX > mouseX ? mouseX : mouseX - actualStringWidth - 8;
            int yOffset = gui.screenHeight - mouseY > mouseY ? mouseY : mouseY - actualStringHeight - 8;
            int horizontalSegmentSize = actualStringWidth + 8;
            int verticalSegmentSize = actualStringHeight + 8;
            mutableTooltipVertices.setSpriteProperties(0, xOffset, -yOffset, 3, 3, 0.390625f, 0.765625f, 0.40234375f, 0.77734375f);
            mutableTooltipVertices.setSpriteProperties(1, xOffset + horizontalSegmentSize - 3, -yOffset, 3, 3, 0.76953125f, 0.765625f, 0.78125f, 0.77734375f);
            mutableTooltipVertices.setSpriteProperties(2, xOffset, -(yOffset + verticalSegmentSize - 3), 3, 3, 0.390625f, 0.98828125f, 0.40234375f, 1.0f);
            mutableTooltipVertices.setSpriteProperties(3, xOffset + horizontalSegmentSize - 3, -(yOffset + verticalSegmentSize - 3), 3, 3, 0.76953125f, 0.98828125f, 0.78125f, 1.0f);
            mutableTooltipVertices.setSpriteProperties(4, xOffset + 3, -yOffset, horizontalSegmentSize - 6, 3, 0.40234375f, 0.765625f, 0.76953125f, 0.77734375f);
            mutableTooltipVertices.setSpriteProperties(5, xOffset + 3, -(yOffset + verticalSegmentSize - 3), horizontalSegmentSize - 6, 3, 0.40234375f, 0.98828125f, 0.76953125f, 1.0f);
            mutableTooltipVertices.setSpriteProperties(6, xOffset, -(yOffset + 3), 3, verticalSegmentSize - 6, 0.390625f, 0.77734375f, 0.40234375f, 0.98828125f);
            mutableTooltipVertices.setSpriteProperties(7, xOffset + horizontalSegmentSize - 3, -(yOffset + 3), 3, verticalSegmentSize - 6, 0.76953125f, 0.77734375f, 0.78125f, 0.98828125f);
            mutableTooltipVertices.setSpriteProperties(8, xOffset + 3, -(yOffset + 3), horizontalSegmentSize - 6, verticalSegmentSize - 6, 0.40234375f, 0.77734375f, 0.76953125f, 0.98828125f);
            AGUIComponent.mutableTooltipRenderable.transform.setTranslation(0.0, 0.0, this.textPosition.z + 25.0);
            mutableTooltipRenderable.render();
            mutableTooltipPosition.set(xOffset + 4, -(yOffset + 4), this.textPosition.z + 50.0);
            RenderText.drawText(tooltipCombinedText.toString(), null, mutableTooltipPosition, ColorRGB.WHITE, RenderText.TextAlignment.LEFT_ALIGNED, 1.0f, false, wrapWidth, true, gui.worldLightValue);
        }
    }

    public List<String> getTooltipText() {
        return null;
    }

    static {
        mutableTooltipRenderable.setLightMode(RenderableData.LightingMode.IGNORE_ALL_LIGHTING);
    }
}

